/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import catserver.server.launch.Java11Support;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLRemappingAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class DeobfuscationTransformer
implements IClassTransformer,
IClassNameTransformer {
    private static final String[] EXEMPT_LIBS = new String[]{"com.google.", "com.mojang.", "joptsimple.", "io.netty.", "it.unimi.dsi.fastutil.", "oshi.", "com.sun.", "com.ibm.", "paulscode.", "com.jcraft"};
    private static final String[] EXEMPT_DEV = new String[]{"net.minecraft.", "net.minecraftforge."};
    private static final boolean RECALC_FRAMES = Boolean.parseBoolean(System.getProperty("FORGE_FORCE_FRAME_RECALC", "false"));
    private static final int WRITER_FLAGS = 1 | (RECALC_FRAMES ? 2 : 0);
    private static final int READER_FLAGS = RECALC_FRAMES ? 4 : 8;
    private boolean deobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!this.shouldTransform(name)) {
            return bytes;
        }
        if (Java11Support.enable && bytes.length > 8 && bytes[7] > 52) {
            bytes[7] = 52;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(WRITER_FLAGS);
        FMLRemappingAdapter remapAdapter = new FMLRemappingAdapter((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)remapAdapter, READER_FLAGS);
        return classWriter.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldTransform(String name) {
        boolean transformLib = Arrays.stream(EXEMPT_LIBS).noneMatch(name::startsWith);
        if (!this.deobfuscatedEnvironment) return transformLib;
        if (!transformLib) return false;
        if (!Arrays.stream(EXEMPT_DEV).noneMatch(name::startsWith)) return false;
        return true;
    }

    public String remapClassName(String name) {
        return FMLDeobfuscatingRemapper.INSTANCE.map(name.replace('.', '/')).replace('/', '.');
    }

    public String unmapClassName(String name) {
        return FMLDeobfuscatingRemapper.INSTANCE.unmap(name.replace('.', '/')).replace('/', '.');
    }
}

